<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-2xl text-gray-800 flex items-center gap-2">
            📂 <span>EMO Uploads</span>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-10 max-w-7xl mx-auto space-y-6">

        
        <div class="flex justify-between items-center">
            <p class="text-gray-600">Manage and track your EMO file uploads.</p>
            <a href="<?php echo e(route('emo.create')); ?>"
               class="px-3 py-1 bg-gray-500 text-white rounded-md hover:bg-gray-700 text-xs font-semibold shadow">
                + New Upload
            </a>
        </div>

        
        <?php if(session('success')): ?>
            <div class="flex items-center gap-3 bg-green-50 border border-green-200 text-green-700 p-4 rounded-lg shadow-sm">
                <span class="text-xl">✅</span>
                <span><?php echo e(session('success')); ?></span>
            </div>
        <?php endif; ?>

        
        <div class="bg-white shadow rounded p-4 overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-100">
                <tr >
                    <th class="p-4">#</th>
                    <th class="p-4">File Name</th>
                    <th class="p-4">Records</th>
                    <th class="p-4">Uploaded On</th>
                    <th class="p-4 text-center">Actions</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                <?php $__empty_1 = true; $__currentLoopData = $uploads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50 transition">
                        <td class="p-4 font-semibold text-gray-700"><?php echo e($u->id); ?></td>
                        <td class="p-4 font-medium text-gray-900 truncate max-w-xs"><?php echo e($u->original_name); ?></td>
                        <td class="p-4">
                            <span class="px-2 py-1 bg-blue-100 text-blue-700 rounded-md text-xs font-semibold">
                                <?php echo e($u->records_count); ?>

                            </span>
                        </td>
                        <td class="p-4 text-gray-600"><?php echo e($u->created_at->format('d-M-Y H:i')); ?></td>
                    <td class="p-4 text-center">
						<div class="inline-flex justify-center gap-2">
							<a href="<?php echo e(route('emo.show', $u)); ?>"
							   class="px-3 py-1 bg-red-600 text-white rounded-md hover:bg-blue-700 text-xs font-semibold shadow">
								View
							</a>
							<a href="<?php echo e(route('emo.print', $u)); ?>"
							   class="px-3 py-1 bg-gray-500 text-white rounded-md hover:bg-gray-700 text-xs font-semibold shadow">
								Print
							</a>
							<!--<a href="<?php echo e(route('emo.pdf', $u)); ?>"
							   class="px-3 py-1 bg-red-600 text-white rounded-md hover:bg-red-700 text-xs font-semibold shadow">
								PDF
							</a>-->
						</div>
					</td>

											</tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="p-6 text-center text-gray-500 italic" colspan="5">No uploads yet.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /opt/lampp/htdocs/lara_postoffice/resources/views/emo/index.blade.php ENDPATH**/ ?>