

<?php $__env->startSection('content'); ?>
    <style>
        .form-control {
            padding-left: 10px !important;
        }
    </style>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <form class="form-submit" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card mb-4 mx-4">
                        <div class="card-header pb-0">
                            <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                                <div>
                                    <h5 class="mb-0">Purchase Product's</h5>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="supplier_id">Supplier:</label>
                                    <div>
                                        <select name="supplier_id" id="supplier_id"
                                            class="form-select supplier_id select2 <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            required>
                                            <option value="" selected disabled>Select Supplier</option>
                                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($supplier->id); ?>" <?php echo e(old('supplier_id') == $supplier->id ? 'selected' : ''); ?>><?php echo e($supplier->supplier_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Payment_date:</label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control"
                                        value="<?php echo e(date('Y-m-d')); ?>">
                                    <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>



                            <div class="product-row card mb-3 position-relative p-3 shadow-lg p-3 mb-5 bg-body-tertiary">
                                <div class="text-end">
                                    <button class="btn btn-primary btn-sm add-row" type="button">+ Add</button>
                                </div>
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <label class="form-label mb-0">Products</label>
                                        <select class="form-select form-select-sm select2 products product_id">
                                            <option value="">Select Product</option>
                                            <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>-<?php echo e($item->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="text-danger error-message" id="error-product_id"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Product Code</label>
                                        <input type="text" class="form-control form-control-sm productCode"
                                            placeholder="Product Code">
                                        <small class="text-danger error-message" id="error-productCode"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Category</label>
                                        <select type="text" class="form-select form-select-sm category_id">
                                            <option value="">Select Category</option>
                                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="text-danger error-message" id="error-category_id"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">HSN Code</label>
                                        <input type="text" class="form-control form-control-sm hsnCode"
                                            placeholder="HSN Code">
                                        <small class="text-danger error-message" id="error-hsnCode"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Quantity</label>
                                        <input type="number" class="form-control form-control-sm qty" placeholder="Qty">
                                        <small class="text-danger error-message" id="error-qty"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Buying Price</label>
                                        <input type="number" class="form-control form-control-sm margin_price"
                                            placeholder="B.P">
                                        <small class="text-danger error-message" id="error-margin_price"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Selling Price</label>
                                        <input type="number" class="form-control form-control-sm unit_price"
                                            placeholder="S.P">
                                        <small class="text-danger error-message" id="error-unit_price"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Description</label>
                                        <input type="text" class="form-control form-control-sm description"
                                            placeholder="Description">
                                        <small class="text-danger error-message" id="error-description"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Total Amount</label>
                                        <input type="number" class="form-control form-control-sm total_amount" readonly
                                            placeholder="Total Amount">
                                        <small class="text-danger error-message" id="error-total_amount"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Payment Type</label>
                                        <select class="form-select form-select-sm payment_type">
                                            <option value="">Select Payment Type</option>
                                            <?php $__currentLoopData = $payment_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->name); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="text-danger error-message" id="error-payment_type"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Paid Amount</label>
                                        <input type="number" class="form-control form-control-sm paid_amount"
                                            placeholder="Paid Amount">
                                        <small class="text-danger error-message" id="error-paid_amount"></small>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive product-table">
                                <table class="table table-bordered table-striped text-xxs">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Product</th>
                                            <th class="text-center">Code</th>
                                            <th class="text-center">Category</th>
                                            <th class="text-center">HSN</th>
                                            <th class="text-center">Qty</th>
                                            <th class="text-center">B.P</th>
                                            <th class="text-center">S.P</th>
                                            <th class="text-center">Total Amount</th>
                                            <th class="text-center">Payment Type</th>
                                            <th class="text-center">Paid Amount</th>
                                            <th class="text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody class="product-body">
                                        <tr>
                                            <td class="text-center" colspan="11">Fill the above details to purchase
                                                products. </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary btn-sm ms-2 saveProduct">Save
                                    Product's</button>
                                <a href="<?php echo e(route('product-index')); ?>" class="btn btn-secondary btn-sm ms-2">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const products = <?php echo json_encode($product, 15, 512) ?>;
        const payType = <?php echo json_encode($payment_type, 15, 512) ?>;

        let selectedProducts = [];
        $(document).ready(function () {
            $('.add-row').on('click', function () {
                addRow();
            });

            $('.saveProduct').on('click', function () {
                let form = $('.form-submit');
                let formData = new FormData(form[0]);
                hasError = false;
                clearValidationErrors();

                // Validate products
                if (selectedProducts.length === 0) {
                    showInlineError('.product-body', 'Please add at least one product');
                    hasError = true;
                }

                // Validate supplier
                let supplierId = $('.supplier_id').val();
                if (!supplierId) {
                    showInlineError('.supplier_id', 'Supplier is required.');
                    hasError = true;
                }

                if (hasError) {
                    return false;
                }
                saveProduct(formData);
            });

            $('.qty').on('input', function () {
                addCalculationEvents();
            });

            $('.margin_price').on('input', function () {
                addCalculationEvents();
            });

            $(document).on('click', '.remove-row', function () {
                $(this).closest('.product-row').remove();
            });

            $(document).on('change', '.products', function () {
                let productId = $(this).val();
                if (productId) {
                    getProductDetails(productId);
                }
            });

            $(document).on('click', '.remove-product', function () {
                const index = $(this).closest('tr').data('index');

                if (index !== undefined && selectedProducts[index]) {
                    selectedProducts.splice(index, 1);
                }

                $(this).closest('tr').remove();

                $('.product-body tr[data-index]').each(function (newIndex) {
                    $(this).attr('data-index', newIndex);
                });

                if ($('.product-body tr').length === 0) {
                    $('.product-body').append(`
                        <tr class="first-row">
                            <td class="text-center" colspan="12">Enter the Product details then Add...</td>
                        </tr>
                    `);
                }

                selectedProducts = selectedProducts.map((product, index) => ({ ...product, index }));
            });

        });

        function addRow() {
            const category_id = $('.category_id').val();
            const category_text = $('.category_id option:selected').text();
            const product_id = $('.product_id').val();
            const name = $('.product_id option:selected').text().split('-')[0].trim();
            const productCode = $('.productCode').val();
            const hsnCode = $('.hsnCode').val();
            const qty = parseFloat($('.qty').val()) || 0;
            const unit_price = parseFloat(parseFloat($('.unit_price').val()).toFixed(2)) || 0;
            const margin_price = parseFloat(parseFloat($('.margin_price').val()).toFixed(2)) || 0;
            const description = $('.description').val();
            const total_amount = parseFloat(parseFloat($('.total_amount').val()).toFixed(2)) || 0;
            const payment_type = $('.payment_type').val().toLowerCase();
            const payment_type_text = payment_type ? $('.payment_type option:selected').text() : '-';
            const paid_amount = parseFloat(parseFloat($('.paid_amount').val()).toFixed(2)) || 0;

            clearValidationErrors();

            let hasError = false;

            if (!product_id) {
                showInlineError('.product_id', 'Product is required.');
                hasError = true;
            }
            if (!qty || qty <= 0) {
                showInlineError('.qty', 'Valid quantity is required.');
                hasError = true;
            }
            if (!unit_price) {
                showInlineError('.unit_price', 'Selling Price is required.');
                hasError = true;
            }
            if (!margin_price) {
                showInlineError('.margin_price', 'Buying Price is required.');
                hasError = true;
            }

            if (paid_amount > 0) {
                if (!payment_type) {
                    showInlineError('.payment_type', 'Payment Type is required.');
                    hasError = true;
                }
            }

            if (hasError) return;

            const product = { category_id, category_text, product_id, name, productCode, hsnCode, qty, unit_price, margin_price, description, total_amount, payment_type, payment_type_text, paid_amount };

            selectedProducts.push(product);

            updateProductTable();

            $('.category_id, .name, .productCode, .hsnCode ,.qty, .unit_price, .margin_price, .description, .payment_type, .paid_amount').val('');
            $('.total_amount').val('0');
            $('.product_id').val('').trigger('change');
        }

        function addCalculationEvents(rowIndex) {
            $(`.qty, .margin_price`).on('input', function () {
                calculateRowTotal(rowIndex);
            });
        }

        function calculateRowTotal(rowIndex) {
            const qty = parseFloat($(`.qty`).val()) || 0;
            const marginPrice = parseFloat($(`.margin_price`).val()) || 0;
            const totalAmount = qty * marginPrice;

            $(`.total_amount`).val(totalAmount.toFixed(2));
        }

        function getProductDetails(productId) {
            const getProduct = products.find(product => product.id == productId);
            if (!getProduct) return;

            $(`.productCode`).val(getProduct.code || '');
            $(`.category_id`).val(getProduct.category_id || '').trigger('change');
            $(`.hsnCode`).val(getProduct.hsn_code || '');

        }

        function clearValidationErrors() {
            $('.error-message').remove();
            $('.is-invalid').removeClass('is-invalid');
            $('.product-body tr').removeClass('border border-danger');
            $('.product-body tr td div.text-danger').remove();
        }

        function showInlineError(selector, message) {
            const input = $(selector);
            input.addClass('is-invalid');

            input.closest('.col-md-2,.col-md-4,.product-table').find('.error-message').remove();

            const errorEl = $(`<small class="text-danger error-message">${message}</small>`);

            if (selector === '.product-body') {
                $('.product-table').before(errorEl);
            }
            else if (input.hasClass('select2')) {
                input.closest('.col-md-2,.col-md-4').append(errorEl);
            }
            else {
                const columnParent = input.closest('[class*="col-md-"]');
                if (columnParent.length) {
                    columnParent.append(errorEl);
                } else {
                    input.after(errorEl);
                }
            }
        }

        function updateProductTable() {
            const $tbody = $('.product-body');
            $tbody.empty();

            if (selectedProducts.length === 0) {
                $tbody.append(`
                                <tr class="first-row">
                                    <td class="text-center" colspan="12">Enter the Product details then Add...</td>
                                </tr>
                            `);
                return;
            }

            selectedProducts.forEach((product, index) => {
                $tbody.append(`
                                <tr data-index="${index}">
                                        <td class="text-center" data-field="name">
                                        <input type="hidden" name = product[${index}][product_id] value="${product.product_id}"/>                                                        
                                        ${product.name}
                                    </td>
                                    <td class="text-center" data-field="productCode">
                                        <input type="hidden" name = product[${index}][productCode] value="${product.productCode}"/> 
                                        ${product.productCode}
                                    </td>
                                    <td class="text-center" data-field="category_id">    
                                        <input type="hidden" name = product[${index}][category_id] value="${product.category_id}"/> 
                                        ${product.category_text}
                                    </td>  
                                        <td class="text-center" data-field="hsnCode">
                                        <input type="hidden" name = product[${index}][hsnCode] value="${product.hsnCode || '-'}"/>                                                        
                                        ${product.hsnCode || '-'}
                                    </td>                                   
                                    <td class="text-center" data-field="qty">
                                        <input type="hidden" name = product[${index}][qty] value="${product.qty}"/>                                                        
                                        ${product.qty}
                                    </td>
                                    <td class="text-center" data-field="margin_price">
                                        <input type="hidden" name = product[${index}][margin_price] value="${product.margin_price || ''}"/>      
                                        <input type="hidden" name = product[${index}][description] value="${product.description || ''}"/>                                                        
                                        ₹ ${product.margin_price}
                                    </td>   
                                    <td class="text-center" data-field="unit_price">
                                        <input type="hidden" name = product[${index}][unit_price] value="${product.unit_price}"/>
                                        ₹ ${product.unit_price}
                                    </td>                                                                                                                                   
                                    <td class="text-center" data-field="total_amount">
                                        <input type="hidden" name = product[${index}][total_amount] value="${product.total_amount || ''}"/>                                                        
                                        ₹ ${product.total_amount}
                                    </td>                   
                                    <td class="text-center" data-field="payment_type">
                                        <input type="hidden" name = product[${index}][payment_type] value="${product.payment_type || ''}"/>                                                                                                                
                                        ${product.payment_type_text}</td>
                                    <td class="text-center" data-field="paid_amount">
                                        <input type="hidden" name = product[${index}][paid_amount] value="${product.paid_amount || ''}"/>                                                                                                                
                                        ₹ ${product.paid_amount || '0'}</td>
                                    <td class="text-center">                      
                                        <a href="javascript:void(0)" class="text-danger remove-product" data-index="${index}">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            `);
            });
        }

        function handleValidationErrors(errors) {
            $('.error-highlight').removeClass('error-highlight');
            $('.row-error').remove();

            if (errors.form) {
                Object.entries(errors.form).forEach(([field, message]) => {
                    $(`.${field}`).addClass('is-invalid');
                    $(`#error-${field}`).text(message);
                });
            }

            if (errors.rows) {
                Object.entries(errors.rows).forEach(([rowIndex, fields]) => {
                    const $row = $(`.product-body tr[data-index="${rowIndex}"]`);

                    $row.addClass('error-highlight');

                    Object.entries(fields).forEach(([field, message]) => {
                        $row.find(`td[data-field="${field}"]`)
                            .append(`<div class="row-error text-danger small">${message}</div>`);
                    });
                });

                $('html, body').animate({
                    scrollTop: $('.error-highlight').first().offset().top - 100
                }, 500);
            }
        }

        function saveProduct(formData) {
            if (!formData) return;

            clearValidationErrors();

            $.ajax({
                url: "<?php echo e(route('product-stock-save')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (response) {
                    if (response.status === 'success') {
                        Swal.fire({
                            title: 'Success!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            selectedProducts = [];
                            updateProductTable();
                            $('.form-submit')[0].reset();
                            $('.select2').val('').trigger('change');
                        });
                    }
                },
                error: function (xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        handleValidationErrors(errors);
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: xhr.responseJSON?.message || 'An error occurred while saving the purchase.',
                            icon: 'error'
                        });
                    }
                }
            });
        }       
    </script>
    <script>
        $(document).ready(function () {
            $('.products').select2({
                placeholder: "Search or type a Product Name",
                allowClear: true,
                tags: true,
                tokenSeparators: [',', ' '],
                width: '100%',
                createTag: function (params) {
                    if (params.term.trim() === '') {
                        return null;
                    }

                    return {
                        id: params.term,
                        text: params.term
                    };
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/products/purchase.blade.php ENDPATH**/ ?>