<?php

namespace NumberToWords\Legacy\Numbers\Words\Locale;

class Ua extends Ru
{
    const LOCALE = 'ua';
    const LANGUAGE_NAME = 'Ukrainian';
    const LANGUAGE_NAME_NATIVE = 'Українська';
    const MINUS = 'мінус';

    protected $zero = 'нуль';

    protected static $ten = [
        ['', 'один', 'два', 'три', 'чотири', 'п\'ять', 'шість', 'сім', 'вісім', 'дев\'ять'],
        ['', 'одна', 'дві', 'три', 'чотири', 'п\'ять', 'шість', 'сім', 'вісім', 'дев\'ять'],
    ];

    protected static $teens = [
        'десять',
        'одинадцять',
        'дванадцять',
        'тринадцять',
        'чотирнадцять',
        'п\'ятнадцять',
        'шістнадцять',
        'сімнадцять',
        'вісімнадцять',
        'дев\'ятнадцять',
    ];

    protected static $tens = [
        2 => 'двадцять',
        'тридцять',
        'сорок',
        'п\'ятдесят',
        'шістдесят',
        'сімдесят',
        'вісімдесят',
        'дев\'яносто',
    ];

    protected static $hundred = [
        '',
        'сто',
        'двісті',
        'триста',
        'чотириста',
        'п\'ятсот',
        'шістсот',
        'сімсот',
        'вісімсот',
        'дев\'ятсот',
    ];

    protected static $mega = [
        [3 => self::FEMALE],
        [3 => self::MALE],
        ['тисяча', 'тисячі', 'тисяч', self::FEMALE],
        ['мільйон', 'мільйони', 'мільйонів', self::MALE],
        ['мільярд', 'мільярди', 'мільярдів', self::MALE],
        ['трильйон', 'трильйони', 'трильйонів', self::MALE],
        ['квадрильйон', 'квадрильйони', 'квадрильйонів', self::MALE],
        ['секстильйон', 'секстильйони', 'секстильйонів', self::MALE],
    ];

    protected static $currencyNames = [
        'ALL' => [
            [1, 'лік', 'ліки', 'ліків'],
            [2, 'кіндарка', 'кіндарки', 'кіндарок'],
        ],
        'AUD' => [
            [1, 'австралійський долар', 'австралійських долара', 'австралійських доларів'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'BGN' => [
            [1, 'лев', 'ліва', 'лівий'],
            [2, 'стотинка', 'стотинки', 'стотинок'],
        ],
        'BRL' => [
            [1, 'бразильський реал', 'бразильських реалів', 'бразильських реалів'],
            [1, 'сентаво', 'сентаво', 'сентаво'],
        ],
        'BYR' => [
            [1, 'білоруський рубль', 'білоруських рубля', 'білоруських рублів'],
            [2, 'копійка', 'копійки', 'копійок'],
        ],
        'CAD' => [
            [1, 'канадський долар', 'канадських долара', 'канадських доларів'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'CHF' => [
            [1, 'швейцарський франк', 'швейцарських франків', 'швейцарських франків'],
            [1, 'сантим', 'сантима', 'сантимів'],
        ],
        'CYP' => [
            [1, 'кіпрський фунт', 'кіпрських фунтів', 'кіпрських фунтів'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'CZK' => [
            [2, 'чеська крона', 'чеських крони', 'чеських крон'],
            [1, 'Галірж', 'Галіржа', 'Галіржа'],
        ],
        'DKK' => [
            [2, 'датська крона', 'датських крони', 'датських крон'],
            [1, 'ері', 'ері', 'ері'],
        ],
        'EEK' => [
            [2, 'естонська крона', 'естонські крони', 'естонські крони'],
            [1, 'сенти', 'сенти', 'сенти'],
        ],
        'EUR' => [
            [1, 'євро', 'євро', 'євро'],
            [1, 'євроцент', 'євроцента', 'євроцентів'],
        ],
        'GBP' => [
            [1, 'фунт стерлінгів', 'фунт стерлінгів', 'фунт стерлінгів'],
            [1, 'пенс', 'пенса', 'пенсів'],
        ],
        'HKD' => [
            [1, 'гонконзький долар', 'гонконзький долар', 'гонконзький долар'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'HRK' => [
            [2, 'хорватська куна', 'хорватські куни', 'хорватських кун'],
            [2, 'липа', 'липи', 'лип'],
        ],
        'HUF' => [
            [1, 'угорський форинт', 'угорських форинтів', 'угорських форинтів'],
            [1, 'філер', 'філера', 'філерів'],
        ],
        'ISK' => [
            [2, 'ісландська крона', 'ісландські крони', 'ісландські крони'],
            [1, 'ері', 'ері', 'ері'],
        ],
        'JPY' => [
            [2, 'єна', 'єни', 'єн'],
            [2, 'сіна', 'сіни', 'сін'],
        ],
        'LTL' => [
            [1, 'літ', 'літа', 'літів'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'LVL' => [
            [1, 'лат', 'лата', 'латів'],
            [1, 'сентим', 'сентима', 'сентимів'],
        ],
        'MKD' => [
            [1, 'македонський динар', 'македонських динарів', 'македонських динарів'],
            [1, 'дені', 'дені', 'дені'],
        ],
        'MTL' => [
            [2, 'мальтійська ліра', 'мальтійські ліри', 'мальтійські ліри'],
            [1, 'сентим', 'сентима', 'сентимів'],
        ],
        'NOK' => [
            [2, 'норвезька крона', 'норвезькі крони', 'норвезьких крон'],
            [0, 'ері', 'ері', 'ери'],
        ],
        'PLN' => [
            [1, 'злотий', 'злотих', 'злотих'],
            [1, 'гроші', 'гроші', 'грошей'],
        ],
        'ROL' => [
            [1, 'румунський лей', 'румунських лей', 'румунських лей'],
            [1, 'бані', 'бані', 'бані'],
        ],
        // both RUR і RUR є використані, деякі users use RUB for shorter form
        'RUB' => [
            [1, 'рубль', 'рубля', 'рублів'],
            [2, 'копійка', 'копійки', 'копійок'],
        ],
        'RUR' => [
            [1, 'російський рубль', 'російських рубля', 'російських рублів'],
            [2, 'копійка', 'копійки', 'копійок'],
        ],
        'SEK' => [
            [2, 'шведська крона', 'шведські крони', 'шведські крони'],
            [1, 'ері', 'ері', 'ері'],
        ],
        'SIT' => [
            [1, 'словенський толар', 'словенських толарів', 'словенських толарів'],
            [2, 'стотин', 'стотин', 'стотин'],
        ],
        'SKK' => [
            [2, 'словацька крона', 'словацьких крони', 'словацьких крон'],
            [0, '', '', ''],
        ],
        'TRL' => [
            [2, 'турецька ліра', 'турецькі ліри', 'турецькі ліри'],
            [1, 'піастр', 'піастра', 'піастрів'],
        ],
        'TRY' => [
            [2, 'турецька ліра', 'турецькі ліри', 'турецькі ліри'],
            [1, 'піастр', 'піастра', 'піастрів'],
        ],
        'UAH' => [
            [2, 'гривня', 'гривні', 'гривень'],
            [2, 'копійка', 'копійки', 'копійок'],
        ],
        'USD' => [
            [1, 'долар США', 'долара США', 'доларів США'],
            [1, 'цент', 'цента', 'центів'],
        ],
        'YUM' => [
            [1, 'югославський динар', 'югославських динарів', 'югославських динарів'],
            [1, 'пара', 'пара', 'пара'],
        ],
        'ZAR' => [
            [1, 'ранд', 'ранда', 'рандів'],
            [1, 'цент', 'цента', 'центів'],
        ]
    ];
}
