@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Companies</h5>
                            </div>
                            <a href="{{ route('company-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp;
                                New Company</a>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body px-0 pt-0 pb-2">
                        {{-- <form action="{{ route('company-index') }}" method="GET">
                            <div class="d-flex justify-content-start align-items-start mb-3 px-3">
                                <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                    placeholder="Search..." style="width: 300px;">
                                <button type="submit" class="btn btn-primary ms-2">Search</button>
                                @if(request('search'))
                                <a href="{{ route('companies.index') }}" class="btn btn-danger ms-2">Reset Filters</a>
                                @endif
                            </div>
                        </form> --}}

                        <div class="table-responsive">
                            <table class="table align-items-center mb-0 table-hover" id="myTable1">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Phone</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Email</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Address</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($companies as $company)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $company->name ?? ''}}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $company->phone ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $company->email ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $company->address ?? ''}}</p>
                                            </td>
                                            <td>
                                                <a href="{{ route('company-edit', $company->id) }}"><i
                                                        class="fa-solid fa-pen-to-square text-secondary"></i></a>
                                                <span class="ms-2">
                                                    <form action="{{ route('company-delete', $company->id) }}" method="POST"
                                                        class="d-inline" id="delete-form-{{ $company->id }}">
                                                        @csrf
                                                        @method('DELETE')
                                                        <i class="cursor-pointer fas fa-trash text-secondary"
                                                            onclick="confirmDelete({{ $company->id }})"></i>
                                                    </form>
                                                </span>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">No companies found.</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    {{-- <div class="card-footer">
                        {{ $companies->links() }}
                    </div> --}}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
    <script>
        $('#myTable1').DataTable();
    </script>
@endpush